/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.parser.DDCCI;
import com.quantumdata.busmon.parser.HDCP;
import com.quantumdata.busmon.parser.I2CMessageType;
import com.quantumdata.busmon.parser.I2CSignal;
import com.quantumdata.busmon.parser.TypeConverter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I2CMessage {
    private static final int sRequiredEDIDBlockSize = 128;
    private static final int sHDCPShortReadRequestStartRegister = 8;
    private static final int sDestinationEnhancedEDIDRead = 96;
    private static final int sDestinationHDCP1 = 116;
    private static final int sDestinationHDCP2 = 118;
    private static final int sDestinationDDCCI = 110;
    private static final int sDestinationEDIDReadWrite = 160;
    private static final int sGetVCPFeatureCommand = 1;
    private static final int sGetVCPFeatureReply = 2;
    private static final String sFileHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String sEDIDHeader = "<HEADER TYPE=\"DID\" VERSION=\"1.0\"></HEADER>";
    private static StringBuffer sEDID = new StringBuffer("");
    private static int sTotalEDIDBlocks = 1;
    private static boolean sGotTotalBlocks = false;
    private static boolean sEDIDComplete = false;
    protected I2CMessageType aMessageType = I2CMessageType.UNKNOWN;
    protected String aDetails = "";
    protected String aExplanation = "";
    protected String aStateMachineTraversal;
    protected String aWhyFaulty;
    protected int aCommand = 0;
    protected int aCurrentValue = 0;
    protected int aDestination = 0;
    protected int aDirection = 0;
    protected int aLength = 0;
    protected int aMaxValue = 0;
    protected int aOpCode = 0;
    protected int aRegister = 0;
    protected int aResultCode = 0;
    protected int aSource = 0;
    protected int aTypeCode = 0;
    protected boolean aIsWrite = false;
    protected boolean aIsFaulty = false;
    public static boolean processingI2CRead = false;
    private static int lastRegister = 0;
    private static int readRegister = 0;

    public I2CMessage() {
    }

    public I2CMessage(Vector<I2CSignal> vector) {
        this();
        int n = 0;
        int n2 = 0;
        ParseState parseState = ParseState.GET_START;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("State Machine Traversal:\n");
        try {
            block34: for (int i = 0; i < vector.size() && parseState != ParseState.ERROR; ++i) {
                n = vector.get(i).getData() & 0xFF;
                n2 = vector.get(i).getType();
                stringBuffer3.append(parseState.toString() + " -> ");
                if (parseState != ParseState.GET_START && n2 == 1) {
                    this.aWhyFaulty = "The parser saw an I2C START condition when none was expected.  This should not be possible during normal bus monitor usage, and constitutes a program malfunction.  Please contact Quantum Data.\n";
                    parseState = ParseState.ERROR;
                    break;
                }
                switch (parseState) {
                    case GET_START: {
                        if (n2 != 1) {
                            this.aWhyFaulty = "The parser did not see an I2C START condition when one was expected.\n";
                            stringBuffer.append("[Missing START]");
                            parseState = ParseState.ERROR;
                            continue block34;
                        }
                        this.aDestination = 0;
                        parseState = ParseState.GET_DESTINATION;
                        continue block34;
                    }
                    case GET_DESTINATION: {
                        this.aDestination |= n & 0xFE;
                        this.aIsWrite = (n & 1) == 0;
                        int n3 = this.aDirection = this.aIsWrite ? 1 : -1;
                        if (n2 != 2) {
                            this.aWhyFaulty = "The parser did not see an I2C destination address when one was expected.\n";
                            stringBuffer.append("[Missing Data]");
                            parseState = ParseState.ERROR;
                            continue block34;
                        }
                        if ((n & 0xF0) == 240) {
                            this.aDestination = (n & 6) << 7;
                            parseState = ParseState.GET_DESTINATION;
                            continue block34;
                        }
                        switch (this.aDestination) {
                            case 96: {
                                this.aMessageType = I2CMessageType.EDID;
                                stringBuffer.append("E-EDID Segment ");
                                stringBuffer2.append("The master requested an Enhanced EDID Read and set the segment to ");
                                parseState = ParseState.GET_EDID_SEGMENT;
                                continue block34;
                            }
                            case 116: 
                            case 118: {
                                this.aMessageType = I2CMessageType.HDCP;
                                if (this.aIsWrite) {
                                    this.aRegister = vector.get(++i).getData() & 0xFF;
                                    if (i == vector.size() - 1) {
                                        stringBuffer.append(String.format("READ %s", HDCP.getShortRegisterName(this.aDestination, this.aRegister)));
                                        stringBuffer2.append(String.format("The master requested a read of register 0x%02X", this.aRegister));
                                    }
                                    lastRegister = this.aRegister;
                                    readRegister = this.aRegister;
                                    parseState = ParseState.GET_HDCP_WRITE_DATA;
                                    processingI2CRead = true;
                                    continue block34;
                                }
                                if (processingI2CRead) {
                                    this.aRegister = readRegister;
                                    lastRegister = readRegister;
                                    stringBuffer.append(String.format("REPLY %s = ", HDCP.getShortRegisterName(this.aDestination, this.aRegister)));
                                    stringBuffer2.append("The master read the following data:\n");
                                } else {
                                    stringBuffer.append("SFR REPLY Ri' = ");
                                    stringBuffer2.append("The master requested an HDCP Short Form Read, and read the following data:\n");
                                    this.aRegister = 8;
                                    lastRegister = 8;
                                    readRegister = 8;
                                }
                                parseState = ParseState.GET_HDCP_DATA;
                                continue block34;
                            }
                            case 110: {
                                this.aMessageType = I2CMessageType.DDCCI;
                                if (this.aIsWrite) {
                                    stringBuffer.append("Command ");
                                    stringBuffer2.append("The master issued the VCP command ");
                                    parseState = ParseState.GET_VCP_COMMAND;
                                    continue block34;
                                }
                                stringBuffer.append("Reply ");
                                stringBuffer2.append("The master requested the VCP Reply ");
                                parseState = ParseState.GET_VCP_REPLY;
                                continue block34;
                            }
                            case 160: {
                                int n4;
                                I2CSignal i2CSignal;
                                int n5;
                                this.aMessageType = I2CMessageType.EDID;
                                if (this.aIsWrite) {
                                    parseState = ParseState.GET_EDID_REQUEST_OFFSET;
                                    continue block34;
                                }
                                stringBuffer.append("Response");
                                stringBuffer2.append("The slave issued a response.\n");
                                if (!sEDIDComplete && (n5 = (i2CSignal = vector.get(n4 = vector.size() - 1)).getType()) != 3) {
                                    I2CMessage.buildEDID(vector);
                                }
                                parseState = ParseState.IGNORE_REST;
                                continue block34;
                            }
                        }
                        this.aMessageType = I2CMessageType.UNKNOWN;
                        stringBuffer.append("I2C");
                        stringBuffer.append(this.aIsWrite ? "W" : "R");
                        stringBuffer2.append("An I2C");
                        stringBuffer2.append(this.aIsWrite ? " Write" : " Read");
                        if ((this.aDestination & 0x300) == 0) {
                            stringBuffer.append(String.format(" %02X", this.aDestination));
                            stringBuffer2.append(" was performed on address");
                            stringBuffer2.append(String.format(" 0x%02X", this.aDestination));
                        } else {
                            stringBuffer.append(String.format(" %03X", this.aDestination));
                            stringBuffer2.append(" was performed on 10-bit address");
                            stringBuffer2.append(String.format(" 0x%03X", this.aDestination));
                        }
                        stringBuffer2.append(".  No further information is available about this message.\n");
                        parseState = ParseState.IGNORE_REST;
                        continue block34;
                    }
                    case GET_HDCP_WRITE_DATA: {
                        this.aRegister = lastRegister;
                        if (n2 == 3) {
                            this.aWhyFaulty = "The parser expected data to write, or an end-of-message, but saw a START condition instead.\n";
                            stringBuffer.append("[Invalid Data]");
                            parseState = ParseState.ERROR;
                            continue block34;
                        }
                        this.aMessageType = I2CMessageType.HDCP;
                        stringBuffer.append(String.format("WRITE %s = ", HDCP.getShortRegisterName(this.aDestination, this.aRegister)));
                        stringBuffer2.append("The master wrote the following data:\n");
                        parseState = ParseState.GET_HDCP_DATA;
                    }
                    case GET_HDCP_DATA: {
                        this.aRegister = lastRegister++;
                        if (n2 == 2) {
                            this.aMessageType = I2CMessageType.HDCP;
                            stringBuffer.append(String.format(" %02X", n));
                            stringBuffer2.append(HDCP.getRegisterNameAndDetails(this.aDestination, this.aRegister, n));
                            parseState = ParseState.GET_HDCP_DATA;
                            continue block34;
                        }
                        i = vector.size();
                        continue block34;
                    }
                    case GET_EDID_SEGMENT: {
                        if (n2 != 2) {
                            this.aWhyFaulty = "The parser did not see an E-EDID segment address when one was expected.\n";
                            stringBuffer.append("Missing Data");
                            parseState = ParseState.ERROR;
                            continue block34;
                        }
                        stringBuffer.append(String.format("%02d ", n));
                        stringBuffer2.append(String.format("%02d (0x%02x).\n", n, n));
                        parseState = ParseState.GET_EOM;
                        continue block34;
                    }
                    case GET_EDID_REQUEST_OFFSET: {
                        if (n2 != 2) {
                            this.aMessageType = I2CMessageType.ERROR;
                            this.aIsFaulty = true;
                            this.aWhyFaulty = "The parser saw an EDID request with no following EDID offset.\n";
                            stringBuffer.append("Request: [Missing Data]");
                            stringBuffer2.append("\nERROR: " + this.aWhyFaulty);
                        } else if (n != 0) {
                            stringBuffer.append(String.format("Request @ Ofs %02d", n));
                            stringBuffer2.append(String.format("The master requested EDID data from offset %02d.\n", n));
                        } else {
                            stringBuffer.append("Request @ Last Offset");
                            stringBuffer2.append("The master requested EDID data continuing from the last offset read.\n");
                        }
                        parseState = ParseState.GET_EOM;
                        continue block34;
                    }
                    case GET_VCP_COMMAND: {
                        this.aSource = vector.get(i).getData();
                        this.aLength = vector.get(++i).getData() & 0x7F;
                        this.aCommand = vector.get(++i).getData();
                        stringBuffer.append(DDCCI.getCommandName(this.aCommand) + ": ");
                        stringBuffer2.append(DDCCI.getCommandName(this.aCommand) + "\n");
                        switch (this.aCommand) {
                            case 1: {
                                this.aOpCode = vector.get(++i).getData();
                                stringBuffer.append(DDCCI.getShortOpcodeName(this.aOpCode));
                                stringBuffer2.append("Opcode ");
                                stringBuffer2.append(DDCCI.getOpcodeName(this.aOpCode));
                                parseState = ParseState.GET_VCP_CHECKSUM;
                                continue block34;
                            }
                            case 2: {
                                this.aWhyFaulty = "This message type cannot be issued by a host device.\n";
                                stringBuffer.append("[Invalid Issuer]");
                                parseState = ParseState.ERROR;
                                continue block34;
                            }
                        }
                        stringBuffer.append(String.format("0x%02X (unknown)", this.aCommand));
                        stringBuffer2.append(String.format(": Unknown message type 0x%02X\nThe parser does not recognize this message type.\n", this.aCommand));
                        parseState = ParseState.IGNORE_REST;
                        continue block34;
                    }
                    case GET_VCP_REPLY: {
                        this.aSource = vector.get(i).getData();
                        this.aLength = vector.get(++i).getData() & 0x7F;
                        this.aCommand = vector.get(++i).getData();
                        stringBuffer.append(DDCCI.getCommandName(this.aCommand));
                        stringBuffer2.append(DDCCI.getCommandName(this.aCommand));
                        switch (this.aCommand) {
                            case 1: {
                                this.aWhyFaulty = "This message type cannot be issued by a display device.\n";
                                stringBuffer.append("Invalid Issuer");
                                parseState = ParseState.ERROR;
                                continue block34;
                            }
                            case 2: {
                                this.aResultCode = vector.get(++i).getData();
                                this.aOpCode = vector.get(++i).getData();
                                this.aTypeCode = vector.get(++i).getData();
                                this.aMaxValue = TypeConverter.composeIntFromSignals(vector, ++i);
                                ++i;
                                this.aCurrentValue = TypeConverter.composeIntFromSignals(vector, ++i);
                                ++i;
                                stringBuffer.append(String.format("%s = ", DDCCI.getShortOpcodeName(this.aOpCode)));
                                stringBuffer2.append(String.format("Opcode %s = ", DDCCI.getOpcodeName(this.aOpCode)));
                                if (this.aResultCode == 1) {
                                    stringBuffer.append("(Unsup)");
                                    stringBuffer2.append("(Unsupported VCP Code)");
                                } else {
                                    stringBuffer.append(DDCCI.getArgumentString(this.aOpCode, this.aCurrentValue));
                                    stringBuffer2.append(DDCCI.getArgumentString(this.aOpCode, this.aCurrentValue));
                                }
                                parseState = ParseState.GET_VCP_CHECKSUM;
                                continue block34;
                            }
                        }
                        stringBuffer.append(String.format("0x%02X (unknown)", this.aCommand));
                        stringBuffer2.append(String.format(": Unknown message type 0x%02X\nThe parser does not recognize this message type.\n", this.aCommand));
                        parseState = ParseState.IGNORE_REST;
                        continue block34;
                    }
                    case GET_VCP_CHECKSUM: {
                        parseState = ParseState.IGNORE_REST;
                        continue block34;
                    }
                    case IGNORE_REST: {
                        if (n2 != 3) continue block34;
                        i = vector.size();
                        continue block34;
                    }
                    case GET_EOM: {
                        if (n2 == 2) {
                            this.aWhyFaulty = "The parser saw extra data when it was expecting a START condition.\n";
                            stringBuffer.append("[Extraneous Data]");
                            parseState = ParseState.ERROR;
                            continue block34;
                        }
                        this.aWhyFaulty = "An I2C STOP at this point is not supported by VESA E-DDC Spec v1.1.  A REPEATED START is expected.\n";
                        stringBuffer.append("[Unexpected STOP]");
                        parseState = ParseState.ERROR;
                        continue block34;
                    }
                    case GET_STOP: {
                        if (n2 == 3) {
                            i = vector.size();
                            continue block34;
                        }
                        this.aWhyFaulty = "The parser did not see an expected STOP signal.\n";
                        stringBuffer.append("[Missing STOP]");
                        parseState = ParseState.ERROR;
                        continue block34;
                    }
                    default: {
                        stringBuffer.append("(?" + parseState.toString() + "?):");
                        stringBuffer2.append("\nPROGRAM ERROR: Parser in unimplemented state ");
                        stringBuffer2.append(parseState.toString() + "\n");
                        parseState = ParseState.IGNORE_REST;
                    }
                }
            }
            switch (parseState) {
                case GET_EDID_SEGMENT: 
                case GET_EDID_REQUEST_OFFSET: 
                case GET_VCP_COMMAND: 
                case GET_VCP_REPLY: 
                case GET_VCP_CHECKSUM: {
                    this.aMessageType = I2CMessageType.ERROR;
                    this.aIsFaulty = true;
                    stringBuffer.append(":EOP");
                    stringBuffer2.append("\nERROR: ");
                    stringBuffer2.append("Unexpected end of packet.\n");
                }
                case ERROR: {
                    this.aMessageType = I2CMessageType.ERROR;
                    this.aIsFaulty = true;
                    stringBuffer2.append("\nERROR: " + this.aWhyFaulty);
                    break;
                }
            }
            stringBuffer2.append("\nEnd of parsing.\n");
            this.aExplanation = stringBuffer.toString();
            this.aDetails = stringBuffer2.toString();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.aMessageType = I2CMessageType.ERROR;
            this.aIsFaulty = true;
            this.aWhyFaulty = "Unexpected end of packet.\n";
            stringBuffer.append(":EOP");
            stringBuffer2.append("\nERROR: " + this.aWhyFaulty);
            this.aExplanation = stringBuffer.toString();
            this.aDetails = stringBuffer2.toString();
        }
        stringBuffer3.append("(END)\n");
        this.aStateMachineTraversal = stringBuffer3.toString();
    }

    public I2CMessageType getMessageType() {
        return this.aMessageType;
    }

    public String getType() {
        String string = "Other I2C";
        switch (this.aMessageType) {
            case DDCCI: {
                string = "DDC/CI";
                break;
            }
            case EDID: {
                string = "EDID";
                break;
            }
            case HDCP: {
                string = "HDCP";
                break;
            }
            case ERROR: {
                string = "BAD I2C";
                break;
            }
            case EMPTY: {
                string = "Empty I2C";
            }
        }
        return string;
    }

    public String getExplanation() {
        return this.aExplanation;
    }

    public String getDetails() {
        String string = this.aDetails;
        if (MainAppFrame.toggleStateTraceAction.isTrue()) {
            string = this.aDetails + "\n\n" + this.aStateMachineTraversal;
        }
        return string;
    }

    public String getDirection() {
        String string = "(n/a)";
        string = this.aDirection > 0 ? "MSTR -> SLAVE" : "SLAVE -> MSTR";
        return string;
    }

    public int getVCPCommand() {
        return this.aCommand;
    }

    public int getVCPOpcode() {
        return this.aOpCode;
    }

    public int getHDCPRegister() {
        return this.aRegister;
    }

    public String getStateMachineTraversal() {
        return this.aStateMachineTraversal;
    }

    public boolean isError() {
        return this.aIsFaulty;
    }

    public String whyError() {
        return this.aWhyFaulty;
    }

    private static void buildEDID(Vector<I2CSignal> vector) {
        String string = I2CMessage.parsedDataToString(vector);
        sEDID.append(string);
        if (!sGotTotalBlocks && sEDID.length() >= 256) {
            String string2 = sEDID.substring(252, 254);
            int n = string2.charAt(0) - 48;
            int n2 = string2.charAt(1) - 48;
            int n3 = n * 16 + n2;
            sTotalEDIDBlocks += n3;
            sGotTotalBlocks = true;
        }
        if (sGotTotalBlocks) {
            int n = 2 * sTotalEDIDBlocks * 128;
            if (sEDID.length() == n) {
                sEDIDComplete = true;
                MainAppFrame.setEnableSaveEDIDOption(true);
            }
        }
    }

    public static void writeXMLEDID(File file) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
            printWriter.println(sFileHeader);
            printWriter.println("<DATAOBJ>");
            printWriter.println("  <HEADER TYPE=\"DID\" VERSION=\"1.0\"></HEADER>");
            printWriter.println("  <DATA>");
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            int n = sEDID.length();
            switch (n) {
                case 256: {
                    string = sEDID.toString();
                    break;
                }
                case 512: {
                    string = sEDID.substring(0, n / 2);
                    string2 = sEDID.substring(n / 2);
                    break;
                }
                case 768: {
                    int n2 = n / 3;
                    string = sEDID.substring(0, n2);
                    string2 = sEDID.substring(n2, 2 * n2);
                    string3 = sEDID.substring(2 * n2);
                    break;
                }
                case 1024: {
                    int n3 = n / 4;
                    string = sEDID.substring(0, n3);
                    string2 = sEDID.substring(n3, 2 * n3);
                    string3 = sEDID.substring(2 * n3, 3 * n3);
                    string4 = sEDID.substring(3 * n3);
                    break;
                }
            }
            printWriter.println("    <BLOCK0>" + string + "</BLOCK0>");
            printWriter.println("    <BLOCK1>" + string2 + "</BLOCK1>");
            printWriter.println("    <BLOCK2>" + string3 + "</BLOCK2>");
            printWriter.println("    <BLOCK3>" + string4 + "</BLOCK3>");
            printWriter.println("  </DATA>");
            printWriter.println("</DATAOBJ>");
            printWriter.close();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            JOptionPane.showMessageDialog(null, string);
        }
    }

    private static String parsedDataToString(Vector<I2CSignal> vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 2; i < vector.size(); ++i) {
            I2CSignal i2CSignal = vector.get(i);
            Integer n = new Integer(i2CSignal.toString());
            int n2 = n;
            if (n2 < 16) {
                stringBuffer.append("0");
            }
            String string = Integer.toHexString(n2).toUpperCase();
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static synchronized void resetEDID() {
        sEDID = new StringBuffer("");
        sTotalEDIDBlocks = 1;
        sGotTotalBlocks = false;
        sEDIDComplete = false;
        MainAppFrame.setEnableSaveEDIDOption(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseState {
        PARSE_BEGIN,
        GET_START,
        GET_DESTINATION,
        GET_EDID_SEGMENT,
        GET_EDID_REQUEST_OFFSET,
        GET_HDCP_REGISTER,
        GET_HDCP_WRITE_DATA,
        GET_HDCP_DATA,
        GET_VCP_COMMAND,
        GET_VCP_REPLY,
        GET_VCP_CHECKSUM,
        GET_DATA,
        GET_STOP,
        GET_EOM,
        IGNORE_REST,
        ERROR;

    }
}

